;*=====================================================================*
;*                                                                     *
;*                 Copyright (c) 1993-2003 nVIDIA Corp.                *
;*                              ALL RIGHTS RESERVED                    *
;*                                                                     *
;*    This program contains proprietary and confidential information.  *
;*    No part of this  material may be reproduced or copied in any     *
;*    tangible medium, or stored in a retrieval system, or transmitted *
;*    in any form without the prior written permission of nVIDIA Corp. *
;*                                                                     *
;*=====================================================================*
;----------------------------------------------------------------------------
;Rev    Date     Name    Description
;----------------------------------------------------------------------------
;N10    09/16/03 YW     Added new function interface 2Ah for GetDimmAddrInfo
;N09    08/05/03 YW     Added code to read smbus 2 BAR instead of use hard coded
;                       one.
;N08    07/23/03 YW     Fixed issue that ReadMBInfo report incorrect vendor ID
;                       and board version.
;N07    07/23/03 YW     Sync this file with wpt.inc under nvaward tree.
;N06    06/23/03 YW     Removed code in GetCPUFanSpeed and GetSecondFanSpeed.
;N05    06/09/03 YW     Removed FSB frequency cmos location and bitmap.
;                       NVTweak will use PCI reg 548h to get FSB speed.
;N04    06/09/03 YW     Added FSB frequency cmos locatin and bitmap to 
;                       GetCMOSLocation0.  Also added OEM_SUBFUNCTION_SUPPORT
;                       to indicate if OEM sub-function is supported or not
;                       in BIOS.
;N03    05/29/03 YW     Changed CMOS interface between WPT and BIOS.
;N02    03/31/03 YW     Added code to calculated cmos checksum after updating
;                       CAS latency.  CAS is within CMOS checksum range. 
;                       Other cmos bits updated are not within checksum range.
;N01    03/28/03 YW     Initial version. Code in SMI provide interface for
;                       WPT (windows performance tool).

.386p
                PAGE    56,132

                include bios.cfg
                include COMMON.MAC
                include chipset.equ
                include wpt.inc
                           
ifdef WPT_INTERFACE_SUPPORT
         
WPTRestoreStack macro
        pop ax
        endm

        ; Function API provided to WPT
        public WPTFunctionTable
WPTFunctionTable:
               ;Function Offset                                                         Function code
        dw      (offset CS:GetInterfaceVersion - offset CS:SMI_Handler_Start)                ;01h
        dw      (offset CS:GetCPUFanSpeed - offset CS:SMI_Handler_Start)                     ;02h
        dw      (offset CS:GetCPUFanPower - offset CS:SMI_Handler_Start)                     ;03h
        dw      (offset CS:SetCPUFanPower - offset CS:SMI_Handler_Start)                     ;04h
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;05h
        dw      (offset CS:GetSecondFanSpeed - offset CS:SMI_Handler_Start)                  ;06h
        dw      (offset CS:GetSecondFanPower - offset CS:SMI_Handler_Start)                  ;07h
        dw      (offset CS:SetSecondFanPower - offset CS:SMI_Handler_Start)                  ;08h
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;09h (Reserved)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;0Ah (For OEM Use as Get Fan Speed)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;0Bh (For OEM Use as Get Fan Power)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;0Ch (For OEM Use as Set Fan Power)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;0Dh (Reserved)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;0Eh (For OEM Use as Get Fan Speed)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;0Fh (For OEM Use as Get Fan Power)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;10h (For OEM Use as Set Fan Power)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;11h (Reserved)    
        dw      (offset CS:GetCPUTemperature - offset CS:SMI_Handler_Start)                  ;12h
        dw      (offset CS:GetMotherBoardTemperature - offset CS:SMI_Handler_Start)          ;13h
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;14h (For OEM Use as get temperature)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;15h (For OEM Use as get temperature)
        dw      (offset CS:GetCPUVoltage - offset CS:SMI_Handler_Start)                      ;16h
ifdef K8_CPU_SUPPORT
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;17h (Not supported in CK8 board)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;18h (Not supported in CK8 board)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;19h (Not supported in CK8 board)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;1Ah (Not supported in CK8 board)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;1Bh (Not supported in CK8 board)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;1Ch (Not supported in CK8 board)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;1Dh (Not supported in CK8 board)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;1Eh (Not supported in CK8 board)    
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;1Fh (Not supported in CK8 board)    
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;20h (For OEM Use as get voltage)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;21h (For OEM Use as set voltage)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;22h (For OEM Use as get voltage)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;23h (For OEM Use as set voltage)
else
        dw      (offset CS:SetCPUVoltage - offset CS:SMI_Handler_Start)                      ;17h
        dw      (offset CS:GetCSCoreVoltage - offset CS:SMI_Handler_Start)                   ;18h
        dw      (offset CS:SetCSCoreVoltage - offset CS:SMI_Handler_Start)                   ;19h
        dw      (offset CS:GetAGPVoltage - offset CS:SMI_Handler_Start)                      ;1Ah
        dw      (offset CS:SetAGPVoltage - offset CS:SMI_Handler_Start)                      ;1Bh
        dw      (offset CS:GetMemoryVoltage - offset CS:SMI_Handler_Start)                   ;1Ch
        dw      (offset CS:SetMemoryVoltage - offset CS:SMI_Handler_Start)                   ;1Dh
        dw      (offset CS:GetAuxVoltage - offset CS:SMI_Handler_Start)                      ;1Eh
        dw      (offset CS:SetAuxVoltage - offset CS:SMI_Handler_Start)                      ;1Fh
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;20h (For OEM Use as get voltage)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;21h (For OEM Use as set voltage)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;22h (For OEM Use as get voltage)
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;23h (For OEM Use as set voltage)
endif   ;K8_CPU_SUPPORT
        dw      (offset CS:ReadActualVoltage - offset CS:SMI_Handler_Start)                  ;24h ReadActualVoltage             ;N07
        dw      (offset CS:ReadMBInfo - offset CS:SMI_Handler_Start)                         ;25h (Get motherboard information) ;N07
        dw      (offset CS:WPTComputeCMOSCheckSumAll - offset CS:SMI_Handler_Start)          ;26h
        dw      (offset CS:GetCMOSLocation0 - offset CS:SMI_Handler_Start)                   ;27h
        dw      (offset CS:GetCMOSLocation1 - offset CS:SMI_Handler_Start)                   ;28h
        dw      (offset CS:DefaultFunc - offset CS:SMI_Handler_Start)                        ;29h reserved ;N10
        dw      (offset CS:GetDimmAddrInfo - offset CS:SMI_Handler_Start)                    ;2Ah          ;N10
              
WPTFunctionTableLen       EQU     ($ - WPTFunctionTable)

        public  CPUVoltageTable    
CPUVoltageTable:
        dd      1.850                   ;1850mV     equ     00h
        dd      1.825                   ;1825mV     equ     01h
        dd      1.800                   ;1800mV     equ     02h
        dd      1.775                   ;1775mV     equ     03h
        dd      1.750                   ;1750mV     equ     04h
        dd      1.725                   ;1725mV     equ     05h
        dd      1.700                   ;1700mV     equ     06h
        dd      1.675                   ;1675mV     equ     07h
        dd      1.650                   ;1650mV     equ     08h
        dd      1.625                   ;1625mV     equ     09h
        dd      1.600                   ;1600mV     equ     0Ah
        dd      1.575                   ;1575mV     equ     0Bh
        dd      1.550                   ;1550mV     equ     0Ch
        dd      1.525                   ;1525mV     equ     0Dh
        dd      1.500                   ;1500mV     equ     0Eh
        dd      1.475                   ;1475mV     equ     0Fh
        dd      1.450                   ;1450mV     equ     10h
        dd      1.425                   ;1425mV     equ     11h
        dd      1.400                   ;1400mV     equ     12h
        dd      1.375                   ;1375mV     equ     13h
        dd      1.350                   ;1350mV     equ     14h
        dd      1.325                   ;1325mV     equ     15h
        dd      1.300                   ;1300mV     equ     16h
        dd      1.275                   ;1275mV     equ     17h
        dd      1.250                   ;1250mV     equ     18h
        dd      1.225                   ;1225mV     equ     19h
        dd      1.200                   ;1200mV     equ     1Ah
        dd      1.175                   ;1175mV     equ     1Bh
        dd      1.150                   ;1150mV     equ     1Ch
        dd      1.125                   ;1125mV     equ     1Dh
        dd      1.100                   ;1100mV     equ     1Eh        
        dd      VOLTAGE_TABLE_END       ;End OF table
               
ifndef K8_CPU_SUPPORT
        
        public  CSCoreVoltageTable    
CSCoreVoltageTable:
        dd      1.70               ;1.70v          00b
        dd      1.60               ;1.60v          01b
        dd      1.60               ;1.60v          02b
        dd      1.50 ;Default      ;1.50v          03b
        dd      VOLTAGE_TABLE_END       ;End OF table
        
        public  AGPVoltageTable    
AGPVoltageTable:
        dd      1.70               ;1.70v          00b
        dd      1.60               ;1.60v          01b
        dd      1.60               ;1.60v          02b
        dd      1.50 ;Default      ;1.50v          03b
        dd      VOLTAGE_TABLE_END       ;End OF table
        
        public  MemoryVoltageTable    
MemoryVoltageTable:
        dd      2.80               ;2.80v          00b
        dd      2.70               ;2.70v          01b
        dd      2.70               ;2.70v          02b
        dd      2.60 ;Default      ;2.60v          03b
        dd      VOLTAGE_TABLE_END       ;End OF table
        
        public  AuxVoltageTable    
AuxVoltageTable:          ;Default is 1.5v
        dd      1.60               ;1.60v          00b
        dd      1.70               ;1.70v          01b
        dd      1.70               ;1.70v          02b
        dd      00000000h               ;NULL           03b
        dd      VOLTAGE_TABLE_END       ;End OF table

;
; Table descpriton for each GPIO pin that controls voltage margin.
;
        public  DefaultVoltageMarginTable
DefaultVoltageMarginTable:
AuxVoltageGPIOTable:
        ;Aux Margin1
        db      AUX_MARGIN1_GPIO12_CTRL         ; GPIO control register
        db      GPIO_CTRL_OUTPUT                ; Set to out function
        db      AUX_GPIO_GROUP                  ; GPIO group data register
        db      AUX_MARGIN1_DEFAULT_STATUS      ; Default Bit status.  Only can be 0 and 1.
        db      AUX_MARGIN1_BIT                 ; Bit number for this GPIO bit in the GPIO group data reg.
GPIOTableSingleSetLen       EQU     ($ - AuxVoltageGPIOTable)
        ;Aux Margin2
        db      AUX_MARGIN2_GPIO17_CTRL
        db      GPIO_CTRL_OUTPUT
        db      AUX_GPIO_GROUP
        db      AUX_MARGIN2_DEFAULT_STATUS
        db      AUX_MARGIN2_BIT
AuxVoltageGPIOTableLen       EQU     ($ - AuxVoltageGPIOTable)

MemoryVoltageGPIOTable:        
        ;Memory margin1
        db      MEM_MARGIN1_GPIO15_CTRL
        db      GPIO_CTRL_OUTPUT
        db      MEM_GPIO_GROUP
        db      MEM_MARGIN1_DEFAULT_STATUS
        db      MEM_MARGIN1_BIT
        ;Memory Margin2
        db      MEM_MARGIN2_GPIO16_CTRL
        db      GPIO_CTRL_OUTPUT
        db      MEM_GPIO_GROUP
        db      MEM_MARGIN2_DEFAULT_STATUS
        db      MEM_MARGIN2_BIT
MemoryVoltageGPIOTableLen       EQU     ($ - MemoryVoltageGPIOTable)

AGPVoltageGPIOTable:
        ;AGP Margin1        
        db      AGP_MARGIN1_GPIO13_CTRL
        db      GPIO_CTRL_OUTPUT
        db      AGP_GPIO_GROUP
        db      AGP_MARGIN1_DEFAULT_STATUS
        db      AGP_MARGIN1_BIT
        ;AGP Margin2
        db      AGP_MARGIN2_GPIO14_CTRL
        db      GPIO_CTRL_OUTPUT
        db      AGP_GPIO_GROUP
        db      AGP_MARGIN2_DEFAULT_STATUS
        db      AGP_MARGIN2_BIT
AGPVoltageGPIOTableLen       EQU     ($ - AGPVoltageGPIOTable)

CSCoreVoltageGPIOTable:
        ;Chipset core Margin1        
        db      CSCORE_MARGIN1_GPIO10_CTRL
        db      GPIO_CTRL_OUTPUT
        db      CSCORE_GPIO_GROUP
        db      CSCORE_MARGIN1_DEFAULT_STATUS
        db      CSCORE_MARGIN1_BIT
        ;Chipset Core Margin2
        db      CSCORE_MARGIN2_GPIO11_CTRL
        db      GPIO_CTRL_OUTPUT
        db      CSCORE_GPIO_GROUP
        db      CSCORE_MARGIN2_DEFAULT_STATUS
        db      CSCORE_MARGIN2_BIT
CSCoreVoltageGPIOTableLen       EQU     ($ - CSCoreVoltageGPIOTable)
        db      VOLTMARGINEN_GPIO43_CTRL
        db      GPIO_CTRL_OUTPUT
        db      VOLTMARGINEN_GPIO_GROUP
        db      MARGINOUTEN_ENABLE_STATUS
        db      MARGINOUTEN_ENABLE_BIT

DefaultVoltageMarginTableLen       EQU     ($ - DefaultVoltageMarginTable)

CPUVoltageGPIOTable:
        ;VID0
        db      CPUVID_OVERRIDE0_GPIO25_CTRL
        db      GPIO_VID_CTRL_OUTPUT
        db      CPUVID_GPIO_GROUP
        db      CPUVID_DEFAULT_STATUS
        db      CPUVID0_GPIO_BIT               
        ;VID1
        db      CPUVID_OVERRIDE1_GPIO26_CTRL
        db      GPIO_VID_CTRL_OUTPUT
        db      CPUVID_GPIO_GROUP
        db      CPUVID_DEFAULT_STATUS
        db      CPUVID1_GPIO_BIT               
        ;VID2
        db      CPUVID_OVERRIDE2_GPIO20_CTRL
        db      GPIO_VID_CTRL_OUTPUT
        db      CPUVID_GPIO_GROUP
        db      CPUVID_DEFAULT_STATUS
        db      CPUVID2_GPIO_BIT               
        ;VID3
        db      CPUVID_OVERRIDE3_GPIO21_CTRL
        db      GPIO_VID_CTRL_OUTPUT
        db      CPUVID_GPIO_GROUP
        db      CPUVID_DEFAULT_STATUS
        db      CPUVID3_GPIO_BIT               
        ;VID4
        db      CPUVID_OVERRIDE4_GPIO22_CTRL
        db      GPIO_VID_CTRL_OUTPUT
        db      CPUVID_GPIO_GROUP
        db      CPUVID_DEFAULT_STATUS
        db      CPUVID4_GPIO_BIT               
       
CPUVoltageGPIOTableLen           EQU     ($ - CPUVoltageGPIOTable)
endif   ; K8_CPU_SUPPORT

;-----------------------------------------------------------------
;
;   WPT_SMI_Entry_Main: This is the main entry for WPT interface.
;       check if it is wpt request and if it is
;       do proper function and return the value.
;   Entry: none;
;   Exit: none;
;   Modfied: none;
;       Data is updated to al and ecx in SMM state save area.
;
WPT_SMI_Entry_Main proc near
        push    ax
        push    bx
        push    ecx
                
        ;read input function code and saved in al.
        ;read input data and saved in ecx
        call    GetInputData
        
        cmp     al, 00h
        je      WPT_SMI_Entry_Main_Invalid     ;invalid function code 
        cmp     al, (WPTFunctionTableLen shr 1)
        ja      WPT_SMI_Entry_Main_Invalid      ;invalid function code
        
        mov     bx, (offset CS:WPTFunctionTable - offset CS:SMI_Handler_Start)
        
        xor     ah, ah
        dec     al                             ;Calculate correct offset for function
        shl     al, 1
        add     bx, ax
        mov     bx, cs:[bx]
        call    bx                            ; return value in ecx
        jc      WPT_SMI_Entry_Main_Execute_Fail ; carry set means failed.
        mov     al, WPT_RETURN_SUCCESS
        jmp     WPT_SMI_Entry_Main_Exit
        
WPT_SMI_Entry_Main_Execute_Fail:
        mov     al, WPT_RETURN_FAIL
        jmp     WPT_SMI_Entry_Main_Exit

WPT_SMI_Entry_Main_Invalid:
        mov     al, WPT_RETURN_INVALID
        
WPT_SMI_Entry_Main_Exit:                
        call    SetReturnData
        
        pop     ecx
        pop     bx
        pop     ax
        ret

WPT_SMI_Entry_Main endp
;------------------------------------------------------------
;
;   GetInputData:
;   input: none
;   output: al has the function code
;           ecx has the data.
;
;
GetInputData proc near
        push    dx
        
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH1_REG
        in      eax, dx
        mov     ecx, eax
        
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_STATUS_REG
        in      al, dx
        
        pop     dx        
        ret
GetInputData endp

;------------------------------------------------------------
;
;   SetReturnData:
;   input: al has the return code;
;          ecx has the return value;
;   output: al and ecx in SMM state save table are updated.
;
;
SetReturnData proc near
        push    dx
        push    si
        push    es
        
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_STATUS_REG
        out     dx, al
        
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH1_REG
        mov     eax, ecx
        out     dx, eax       
        
        pop     es
        pop     si
        pop     dx        
        ret
SetReturnData endp
;------------------------------------------------------------
;
;   DefaultFunc:
;
;   output: jump to WPT_SMI_Entry_Main_Invalid label
;

DefaultFunc proc near

        WPTRestoreStack
        jmp     WPT_SMI_Entry_Main_Invalid
DefaultFunc endp
;------------------------------------------------------------
;
;   GetInterfaceVersion:
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
GetInterfaceVersion proc near

        mov     ecx, (OEM_SUBFUNCTION_SUPPORT shl 16) + WPT_INTERFACE_VERSION   ;N04
        
        clc
        ret

GetInterfaceVersion endp


;------------------------------------------------------------
;
; GetCPUTemperature
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
GetCPUTemperature proc near

        push    ax

        call    EnableHWMonitor
        jc      GetCPUTemperatureError
        mov     bl, HW_MONITOR_SMBUS_READ_ADDR
        mov     al, CPU_TEMP_SMBUS_OFFSET
        call    CS_I2cReadByte
        jc      GetCPUTemperatureError
        
        movzx   ecx, bh   ;Save current temperature in ecx     ;N07 
        mov     ch, CPU_TEMP_THRESHOLD                         ;N07
        clc            
GetCPUTemperatureError:
        pop     ax
        ret
GetCPUTemperature endp


;------------------------------------------------------------
;
; GetMotherBoardTemperature
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
GetMotherBoardTemperature proc near

        push    ax
        
        call    EnableHWMonitor
        jc      GetMBTemperatureError
        
        mov     bl, HW_MONITOR_SMBUS_READ_ADDR
        mov     al, BOARD_TEMP_SMBUS_OFFSET
        call    CS_I2cReadByte
        jc      GetMBTemperatureError
        
        movzx   ecx, bh
        mov     ch, MB_TEMP_THRESHOLD                       ;N07
        clc
GetMBTemperatureError:
        pop     ax
        ret
GetMotherBoardTemperature endp


;------------------------------------------------------------
;
; EnableHWMonitor
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
EnableHWMonitor proc near

        push    ax
        push    bx
        
        mov     bl, HW_MONITOR_SMBUS_READ_ADDR
        mov     al, SMSC_LPC47M15_SMB_REG_CONFIGURATION
        call    CS_I2cReadByte
        jc      EnableHWMonitorExit
        
        test    bh, 1
        jnz     EnableHWMonitorExit        ;jump if HWMonitor already enabled.
        
        or      bh, 21h
        mov     bl, HW_MONITOR_SMBUS_WRITE_ADDR
        mov     al, SMSC_LPC47M15_SMB_REG_CONFIGURATION
        call    CS_I2CWriteByte
        
EnableHWMonitorExit:
        pop     bx
        pop     ax
        ret
EnableHWMonitor endp

;N09 start
;[]======================================================================[]
; GetSmbus2Bar: Get smbus 2 base address
;
;Input    : none
;Output   : cx has the bar.
; 
;[]======================================================================[]
GetSmbus2Bar proc near
        push    ax
        push    bx
        mov     bl, 0
        mov     cx, MCP2_SMBUS+054h     ; smbus 2 bar register
        call    SMI_GET_PCI_DWORD
        and     ax, 0FFC0h              ; clear lower 6 bits
        mov     cx, ax
        pop     bx
        pop     ax

        ret                 
GetSmbus2Bar endp
;N09 end

;[]======================================================================[]
; CS_I2CReadByte: this is the exact copy from chipboot.asm I2CByteRead
;               code in chipboot.asm will not exist anymore after system
;               boot to OS. This is used only for SMM mode.
;
;Input    : BL - 8 bits I2C ID address,AL - byte index
;Output   : BH - value return if carry cleared
;           Fail - if carr set
;[]======================================================================[]
CS_I2CReadByte  Proc    Near
        push    dx
                
        call    GetSmbus2Bar          ;Get bar in cx         ;N09  
        ; Disable stuff in extended control reg.
        push    ax
        mov     al, 00
        mov     dx, cx                ;N09
        add     dx, 3Eh               ;N09
        out     dx, al
        
        ;Send a not in use to protocol reg.
        mov     dx, cx                  ;N09
        out     dx, al
        
        pop     ax
        
        mov     ah, al                  ; byte index
        mov     al, bl
        mov     dx, cx                  ;N09
        add     dx, 02h                 ;N09
        out     dx, ax                  ; address and index
        ; wait SMbus ready
        ;ROM_CALL Chk_SMBus_READY ;N18
        ; start I2C read operation
        newiodelay
        mov     dx, cx                  ;N09
        mov     al, 07h                 ; MCP_SMB_PRTCL_PROTOCOL_READ_BYTE
        out     dx, al
        newiodelay
        ; check status OK ?
        call    CS_Chk_SMBus_READY
        jc      CS_I2C_ReadFail          ; SMBus Fail
        newiodelay
        ; read data
        mov     dx, cx                   ;N09
        add     dx, 04h    ; MCP_CONST_SMB1_BASE + MCP_SMB_DATA_00   ;N09
        in      al, dx
        mov     bh, al                  ; value return
CS_I2C_ReadFail:

        pop     dx
        ret
CS_I2CReadByte  Endp
;-------------------------------------------------
; CS_I2CWriteByte: this is the exact copy from chipboot.asm I2CByteWrite
;               code in chipboot.asm will not exist anymore after system
;               boot to OS. This is used only for SMM mode.
;
;Input    : BL - 8 bits I2C ID address,AL - byte index
;         : BH - value to write
;Output   : Fail - if carr set
;-------------------------------------------------
CS_I2CWriteByte    Proc    Near
        push    dx

        call    GetSmbus2Bar          ;Get bar in cx         ;N09  
        
        mov     ah, al                  ; byte index
        mov     al, bl
        mov     dx, cx                  ;N09
        add     dx, 02h                 ;N09
        out     dx, ax                  ; address and index
        newiodelay
        ; put data to SMbus Base + 6
        mov     al, bh
        mov     dx, cx                  ;N09
        add     dx, 04h                 ;N09
        out     dx, al                  ; Data0
        newiodelay
        ; wait SMbus ready
        call    CS_Chk_SMBus_READY
        ; start I2C write operation
        newiodelay
        mov     dx, cx                  ;N09
        mov     al, 06h                 ; MCP_SMB_PRTCL_PROTOCOL_WRITE_BYTE
        out     dx, al
        ; check status OK ?
        call    CS_Chk_SMBus_READY
        
        pop     dx
        ret
CS_I2CWriteByte    Endp
;[]======================================================================[]
; CS_Chk_SMBus_READY: this is the exact copy from chipboot.asm Chk_SMBus_READY
;               code in chipboot.asm will not exist anymore after system
;               boot to OS. This is used only for SMM mode.
;
;Input  : cx has smbus bar
;Output : Carry set means error; carry clear means ready.
;[]======================================================================[]
        
CS_Chk_SMBus_READY      Proc    Near
        push    dx
        push    cx
        push    ax
        
        mov     dx, cx       ;N09
        add     dx,  01h     ;Status port ;N09
        clc
        
        mov     cx, 2000h
CS_Chk_I2C_OK:
        newiodelay
        in      al, dx                   ;get status
        or      al, al                   ;N18
        jz      CS_Chk_I2C_OK            ;not ready

        test    al, 80h                  ;is finished
        jnz     CS_Clear_final

        test    al, 01Fh
        jz      CS_Clear_final

        and     al, 01Fh
        cmp     al, 01Ah                ; SMBus busy?
        jne     CS_SMBus_Err

        ;out     dx, al                   ;clear status
        loop    CS_Chk_I2C_OK

CS_SMBus_Err:
        
        stc
CS_Clear_final:
        out     dx, al                   ;clear status
        pop     ax
        pop     cx
        pop     dx
        ret
CS_Chk_SMBus_READY      Endp

ifndef K8_CPU_SUPPORT
        
;------------------------------------------------------------
;
; EnableVoltageMargin: Default table loaded. 
;
; Entry: si: table length
;        di: tabel offset
;        dl: gpio override status. bit 0 = 1: override with new data
;                                        = 0: don't override
;        dh: bit 0 is the data for gpio override if override is enabled,  
; Exit:  di: is in the end of the table
; Modified:
;

EnableVoltageMargin proc near
        push    ax
        push    cx
        
        ; Set GPIO to proper status
SetNextGPIOReg:
        mov     ah, cs:[di]
        mov     al, cs:[di+1]
        call    SuperIORegWrite
        
        mov     ah, cs:[di+2]
        call    SuperIORegRead
        mov     cx, cs:[di+3]

        xchg    ch, cl
        ror     al, cl
        and     al, 0FEh
        rol     al, cl
        xchg    ch, cl
        
        test    dl, 1              ;Check for override
        jz      NoOverrideVoltage
        mov     cl, ch
        shl     dh, cl
        mov     cl, dh
                 
NoOverrideVoltage:
        or      al, cl
                
        call    SuperIORegWrite
        
        add     di, GPIOTableSingleSetLen
        sub     si, GPIOTableSingleSetLen
        cmp     si, 0
        jne     SetNextGPIOReg

        pop     cx
        pop     ax        
        ret
EnableVoltageMargin endp
        
;------------------------------------------------------------
;
; EnableDefaultVoltMargin: Enable Volt_Margin_Outen 
;
; Entry:  
; Exit: 
; Modified:
;
EnableDefaultVoltMargin proc near

        push    si
        push    di
        push    dx
        
        xor     dx, dx              ;no override for default data
        mov     si, DefaultVoltageMarginTableLen
        mov     di, (offset CS:DefaultVoltageMarginTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        call    EnableVoltageMargin
        
        clc
        pop     dx
        pop     di
        pop     si

        ret
EnableDefaultVoltMargin endp

;------------------------------------------------------------
;
; GetVoltMarginOutenStatus: Check status of Volt_margin_out_en
;
; Entry:  
; Exit: carry set if enabled (override enabled)
; Modified:
;
GetVoltMarginOutenStatus proc near
        push    ax

        ;check if gpio as output and gpio function.
        mov     ah, VOLTMARGINEN_GPIO43_CTRL
        call    SuperIORegRead
        and     al, GPIO_CTRL_OUTPUT_MASK        
        cmp     al, 0
        jne     MarginNotEnabled
        
        mov     ah, VOLTMARGINEN_GPIO_GROUP
        call    SuperIORegRead
        test    al, VOLTMARGINEN_GPIOMASK
        jnz     MarginNotEnabled      ; Set to 0 means enable voltage margin.           ;N07
        stc
        jmp     GetVoltageStatusExit
MarginNotEnabled:
        clc        
GetVoltageStatusExit:
        pop     ax

        ret
GetVoltMarginOutenStatus endp

;------------------------------------------------------------
;
; EnableVIDOverrideCtrl: Enable Volt_Margin_Outen 
;
; Entry:  
; Exit: 
; Modified:
;
EnableVIDOverrideCtrl proc near

        push    ax

        ;Enable gpio as output and gpio function.
        mov     ah, VID_OVERRIDE_GPIO55_CTRL
        mov     al, GPIO_CTRL_OUTPUT
        call    SuperIORegWrite        
        
        mov     ah, VID_OVERRIDE_GPIO_GROUP
        call    SuperIORegRead
        or      al, VID_OVERRIDE_GPIOMASK
        call    SuperIORegWrite
        
        pop     ax
                
        ret
EnableVIDOverrideCtrl endp

;------------------------------------------------------------
;
; GetVIDOverrideCtrlStatus: Check status of VID_OVERRIDE_CTRL
;
; Entry:  
; Exit: carry set if enabled (override enabled)
; Modified:
;
GetVIDOverrideCtrlStatus proc near

        push    ax

        ;check if gpio as output and gpio function.
        mov     ah, VID_OVERRIDE_GPIO55_CTRL
        call    SuperIORegRead
        and     al, GPIO_CTRL_OUTPUT_MASK        
        cmp     al, 0
        jne     MarginNotEnabled
        
        mov     ah, VID_OVERRIDE_GPIO_GROUP
        call    SuperIORegRead
        test    al, VID_OVERRIDE_GPIOMASK
        jz      VIDOverrideNotEnabled
        stc
        jmp     GetVIDOverrideStatusExit
VIDOverrideNotEnabled:
        clc        
GetVIDOverrideStatusExit:
        pop     ax

        ret
GetVIDOverrideCtrlStatus endp

;------------------------------------------------------------
;
; SetOverrideVoltage: 
;
; Entry:  di: offset that GPIO table start
;         si: Table length
;         al: data to set
; Exit:   Carry set means failure.
; Modified:
;
SetOverrideVoltage proc near
        push    dx
        push    cx
        
        mov     cx, si              ;cx used make a loop for how many bit is to set.
SetNextOverrideVolMargin:
        mov     dl, 1               ; Override with data in dh
        mov     dh, al
        and     dh, 01h            ; bit 0 for Margin 1
        mov     si, GPIOTableSingleSetLen
        ;When this loop run on second time
        ;di has the value point to next entry of the table.
        call    EnableVoltageMargin
        
        sub     cx, GPIOTableSingleSetLen
        shr     al, 1
        cmp     cx, 0
        jne     SetNextOverrideVolMargin
        
        pop     cx
        pop     dx
        ret
SetOverrideVoltage endp

;------------------------------------------------------------
;
; GetOverrideGPIOVoltage: 
;
; Entry:  di: offset that GPIO table start
;         si: Table length
;         
; Exit: if carry clear, ax has the data get.  
;       Carry set means GPIO is not used to control voltage.
; Modified:
;

GetOverrideGPIOVoltage proc near
        push    bx
        push    cx

        xor     bx, bx
        
GetGPIOVolNextTBLSet:
        mov     ah, cs:[di]
        call    SuperIORegRead
        cmp     al, cs:[di+1]
        jne     GetGPIOVoltageNotEnable
        mov     ah, cs:[di+2]
        call    SuperIORegRead
        mov     cx, cs:[di+3]
        xchg    ch, cl
        shr     al, cl
        rcr     al, 1       ;shift bit 0 to carry
        rcr     bl, 1       ;Shift carry to bl bit 7
        add     di, GPIOTableSingleSetLen
        inc     bh
        sub     si, GPIOTableSingleSetLen
        cmp     si, 0
        je      GetGPIOVoltageEnabled
        jmp     GetGPIOVolNextTBLSet
GetGPIOVoltageNotEnable:
        stc        
        jmp     GetGPIOVoltageExit
GetGPIOVoltageEnabled:
        ;At this point
        ;Data is in bl from bit 7 to 6.
        ; bh has the count how many rcr is done.
        ; compute how many shr still left to be done.
        mov     al, 8        
        sub     al, bh       
        mov     cl, al
        shr     bl, cl
        movzx   ax, bl      ;al has the data.
        clc
GetGPIOVoltageExit:        
        pop     cx
        pop     bx
        ret
GetOverrideGPIOVoltage endp

;------------------------------------------------------------
;
; GetAuxVoltage: 
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
GetAuxVoltage proc near
        push    ax
        push    bx
        
        ;Check smb_alert                                    ;N07
        mov     dx, SMI_IO_BASE_ADDR+MCP2_GPIO39_REG        ;N07
        in      al, dx                                      ;N07
        test    al, 1h          ;check bit 0                ;N07
        jz      GetStandardAuxVolt      ; bit 0 is 0 means it is standard 1.5v. ;N07
        
        ;Check VoltMarginOutenStatus                                 
        call    GetVoltMarginOutenStatus
        jnc     GetStandardAuxVolt
        
        mov     si, AuxVoltageGPIOTableLen
        mov     di, (offset CS:AuxVoltageGPIOTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        call    GetOverrideGPIOVoltage
        jc      GetStandardAuxVolt
            
        mov     bx, (offset CS:AuxVoltageTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        shl     ax, 2
        add     bx, ax
        mov     ecx, cs:[bx]        ;Set voltage to ecx
        
        jmp     AuxVoltConvert
GetStandardAuxVolt:
        mov     ecx, AUX_DEFAULT_VOLTAGE_1500       ;Give default voltage to ecx
AuxVoltConvert:

        clc
        pop     bx
        pop     ax
        ret
GetAuxVoltage endp
;------------------------------------------------------------
;
; FindVoltageInTable: 
;
; Entry:  ecx has the Voltage value;
;         di: has the Voltage Table offset
; Exit:   al: return the corresponding entry in the table.
;         Carry set means failure.
; Modified:
;
FindVoltageInTable proc near 
        push    dx       
        ;find voltage in table        
        xor     al, al
FindVoltageAgain:
        cmp     ecx, cs:[di]
        je      GotVoltageInTable
        add     di, 4
        inc     al
        mov     dl, cs:[di+3]
        test    dl, 80h    ;voltage won't be negative.
        jnz     FindVoltageFail
        jmp     FindVoltageAgain
        
FindVoltageFail:
        stc
        jmp     FindVoltageExit
GotVoltageInTable:
        clc
FindVoltageExit:
        pop     dx        
        ret
FindVoltageInTable endp


;------------------------------------------------------------
;
; SetAuxVoltage: 
;
; Entry:  ecx has the value to set
; Exit:   Carry set means failure.
; Modified:
;
SetAuxVoltage proc near
        push    ax
        push    si
        push    di
        ;find voltage in table        
        mov     di, (offset CS:AuxVoltageTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        call    FindVoltageInTable
        jc      SetAuxVoltageExit    ;Voltage not found then exit.
        
        ;Set smb_alert as GPIO output                       ;N07
        mov bl, al       ; save al in bl                    ;N07
        mov dx, SMI_IO_BASE_ADDR+MCP2_GPIO39_REG            ;N07
        mov al, 65h     ;set to gpio output and high        ;N07
        out dx, al                                          ;N07
        mov al, bl      ;restore al                         ;N07
        
        ;Check VoltMarginOutenStatus                                
        call    GetVoltMarginOutenStatus
        jc      SetAuxVoltageMarginEnabled
        
        call    EnableDefaultVoltMargin
        
SetAuxVoltageMarginEnabled:
        mov     di, (offset CS:AuxVoltageGPIOTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        mov     si, AuxVoltageGPIOTableLen
        ;data in al already
        call    SetOverrideVoltage
        
        clc
SetAuxVoltageExit: 
        pop     di
        pop     si       
        pop     ax
        ret
SetAuxVoltage endp


;------------------------------------------------------------
;
; GetMemoryVoltage: 
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
GetMemoryVoltage proc near
        push    ax
        push    bx
        
        call    GetVoltMarginOutenStatus
        jnc     GetStandardMemoryVolt
        
        mov     si, MemoryVoltageGPIOTableLen
        mov     di, (offset CS:MemoryVoltageGPIOTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        call    GetOverrideGPIOVoltage
        jc      GetStandardMemoryVolt
        
        mov     bx, (offset CS:MemoryVoltageTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        shl     ax, 2
        add     bx, ax
        mov     ecx, cs:[bx]        ;Set voltage to ecx
        
        
        jmp     MemoryVoltConvert
GetStandardMemoryVolt:
        mov     ecx, MEM_DEFAULT_VOLTAGE_2600        
MemoryVoltConvert:
        
        clc
        pop     bx                       
        pop     ax
        ret
GetMemoryVoltage endp

;------------------------------------------------------------
;
; SetMemoryVoltage: 
;
; Entry:  ecx has the value to set
; Exit:   Carry set means failure.
; Modified:
;
SetMemoryVoltage proc near
        push    ax
        push    si
        push    di
        ;find voltage in table        
        mov     di, (offset CS:MemoryVoltageTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        call    FindVoltageInTable
        jc      SetMemVoltageExit
        
        call    GetVoltMarginOutenStatus
        jc      SetMemVoltageMarginEnabled
        
        call    EnableDefaultVoltMargin
        
SetMemVoltageMarginEnabled:
        mov     di, (offset CS:MemoryVoltageGPIOTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        mov     si, MemoryVoltageGPIOTableLen
        ;data in al already
        call    SetOverrideVoltage
        
        clc
SetMemVoltageExit:
        pop     di
        pop     si
        pop     ax
        ret
SetMemoryVoltage endp

;------------------------------------------------------------
;
; GetAGPVoltage: 
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
GetAGPVoltage proc near
        push    ax
        push    bx
        
        call    GetVoltMarginOutenStatus
        jnc     GetStandardAGPVolt
        
        mov     si, AGPVoltageGPIOTableLen
        mov     di, (offset CS:AGPVoltageGPIOTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        call    GetOverrideGPIOVoltage
        jc      GetStandardAGPVolt
        
        mov     bx, (offset CS:AGPVoltageTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        shl     ax, 2
        add     bx, ax
        mov     ecx, cs:[bx]        ;Set voltage to ecx
        
        jmp     AGPVoltConvert
GetStandardAGPVolt:
        mov     ecx, AGP_DEFAULT_VOLTAGE_1500        
AGPVoltConvert:
        
        clc
        pop     bx
        pop     ax
        ret
GetAGPVoltage endp

;------------------------------------------------------------
;
; SetAGPVoltage: 
;
; Entry:  ecx has the value to set
; Exit:   Carry set means failure.
; Modified:
;
SetAGPVoltage proc near
        push    ax
        push    si
        push    di
        ;find voltage in table        
        mov     di, (offset CS:AGPVoltageTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        call    FindVoltageInTable
        jc      SetAGPVoltageExit
        
        call    GetVoltMarginOutenStatus
        jc      SetAGPVoltageMarginEnabled
        
        call    EnableDefaultVoltMargin
SetAGPVoltageMarginEnabled:
        mov     di, (offset CS:AGPVoltageGPIOTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        mov     si, AGPVoltageGPIOTableLen
        ;data in al already
        call    SetOverrideVoltage
        
        clc        
SetAGPVoltageExit:
        pop     di
        pop     si
        pop     ax
        ret
SetAGPVoltage endp

;------------------------------------------------------------
;
; GetCSCoreVoltage: 
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
GetCSCoreVoltage proc near
        push    ax
        push    bx
        
        call    GetVoltMarginOutenStatus
        jnc     GetStandardCSCoreVolt
        
        mov     si, CSCoreVoltageGPIOTableLen
        mov     di, (offset CS:CSCoreVoltageGPIOTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        call    GetOverrideGPIOVoltage
        jc      GetStandardCSCoreVolt
        
        mov     bx, (offset CS:CSCoreVoltageTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        shl     ax, 2
        add     bx, ax
        mov     ecx, cs:[bx]        ;Set voltage to ecx
        
        jmp     CSCoreVoltConvert
GetStandardCSCoreVolt:
        mov     ecx, CSCORE_DEFAULT_VOLTAGE_1500        
CSCoreVoltConvert:
        
        clc
        pop     bx        
        pop     ax
        ret
GetCSCoreVoltage endp

;------------------------------------------------------------
;
; SetCSCoreVoltage: 
;
; Entry:  ecx has the value to set
; Exit:   Carry set means failure.
; Modified:
;
SetCSCoreVoltage proc near
        push    ax
        push    si
        push    di
        ;find voltage in table        
        mov     di, (offset CS:CSCoreVoltageTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        call    FindVoltageInTable
        jc      SetCSCoreVoltageExit
        
        call    GetVoltMarginOutenStatus
        jc      SetCSCoreVoltageMarginEnabled
        
        call    EnableDefaultVoltMargin
SetCSCoreVoltageMarginEnabled:        
        mov     di, (offset CS:CSCoreVoltageGPIOTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        mov     si, CSCoreVoltageGPIOTableLen
        ;data in al already
        call    SetOverrideVoltage
        
        clc
SetCSCoreVoltageExit:
        pop     di
        pop     si
        pop     ax
        ret
SetCSCoreVoltage endp

;------------------------------------------------------------
;
; SetCPUVoltage: 
;
; Entry:  ecx has the value to set
; Exit:   Carry set means failure.
; Modified:
;
SetCPUVoltage proc near
        push    ax
        push    di
        
        ;find voltage in table        
        mov     di, (offset CS:CPUVoltageTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        call    FindVoltageInTable
        jc      SetCPUVoltageError    ;Voltage not found then exit.
        
        mov     di, (offset CS:CPUVoltageGPIOTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        mov     si, CPUVoltageGPIOTableLen
        ;data in al already
        call    SetOverrideVoltage
                
        call    EnableVIDOverrideCtrl
        clc
        jmp     SetCPUVoltageExit
        
SetCPUVoltageError:
        stc        
SetCPUVoltageExit:
        pop     di
        pop     ax
        ret
SetCPUVoltage endp

endif ;K8_CPU_SUPPORT

;------------------------------------------------------------
;
; GetCPUVoltage: 
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
GetCPUVoltage proc near

        push    ax
        push    bx
        
        call    EnableHWMonitor
        jc      GetCPUVoltageError
        mov     bl, HW_MONITOR_SMBUS_READ_ADDR
        mov     al, CPU_VID_SMBUS_OFFSET
        call    CS_I2cReadByte
        jc      GetCPUVoltageError
        mov     cl, bh
        mov     bl, HW_MONITOR_SMBUS_READ_ADDR
        mov     al, CPU_VID4_SMBUS_OFFSET
        call    CS_I2cReadByte
        jc      GetCPUVoltageError
        and     bh, 01h
        shl     bh, 4
        and     cl, 0Fh
        or      bh, cl
        movzx   ax, bh
    
        shl     ax, 2       ;Every VID occupies 4 bytes.
        mov     bx, (offset CS:CPUVoltageTable - offset CS:SMI_Handler_Start)     ;find voltage in table
        add     bx, ax
        mov     ecx, cs:[bx]        ;Set voltage to ecx
        
        clc            
GetCPUVoltageError:
        pop     bx
        pop     ax

        ret
GetCPUVoltage endp

;N07 start
;------------------------------------------------------------
;
; ReadActualVoltage: function code 24h.
;
;   output: voltage data is saved in scratch register from  to 5
;       scratch register 1: cpu voltage
;       scratch register 2: chipset voltage
;       scratch register 3: agp voltage
;       scratch register 4: memory voltage
;       scratch register 5: aux voltage
;       
;       Not supported will be return all FFs.
;
ReadActualVoltage proc near
        
        ; nVidia CRB board is not supporting reading actual voltage.
        WPTRestoreStack
        jmp     WPT_SMI_Entry_Main_Invalid
        
;        ret                      
ReadActualVoltage endp
;N07 end

;------------------------------------------------------------
;
; GetCPUFanSpeed
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
GetCPUFanSpeed proc near
        WPTRestoreStack                              ;N06
        jmp     WPT_SMI_Entry_Main_Invalid           ;N06
GetCPUFanSpeed endp

;------------------------------------------------------------
;
; GetSecondFanSpeed
;
;   output: data is saved in ecx
;       carry clear means success; else means failure
;
GetSecondFanSpeed proc near
        WPTRestoreStack                              ;N06
        jmp     WPT_SMI_Entry_Main_Invalid           ;N06
GetSecondFanSpeed endp

;------------------------------------------------------------
;
; GetCPUFanPower: 
;
; Entry:  
; Exit: ecx has the CPU Fan power, carry clear
; Modified:
;
GetCPUFanPower proc near
        push ax
        
        ;Check To see if Fan1 control is activated.
        mov     ah, FAN1_GPIO33_CTRL_INDEX
        call    SuperIORegRead
        mov     ecx, FAN_FULL_POWER         ;preset to full power.
        test    al, 4                      ;Bit 2 enables Fan control
        jz      GetCPUFanPowerExit
        
        mov     ah, FAN1_POWER_INDEX
        call    SuperIORegRead
        test    al, 1                      ;If Fan1 pin is high
        jnz     GetCPUFanPowerExit         ; yes, then jump with full power return
        shl     al, 1       ;only bit 1 to 6 are used for fan power.
                        ; and change data range within 00 and FE instead of 0-63.
        xor     ah, ah
        movzx   ecx, ax
GetCPUFanPowerExit:
        
        clc    
        pop     ax    
        ret
GetCPUFanPower endp

;------------------------------------------------------------
;
; SetCPUFanPower: 
;
; Entry:  cx (actually cl) has the CPU Fan power to set
; Exit:   carry clear means success
; Modified:
;
SetCPUFanPower proc near
        jmp DefaultFunc

ifdef   SETCPUFANPOWER_DISABLE
        push    ax
        
        ;Make Fan1 control active.
        mov     ah, FAN1_GPIO33_CTRL_INDEX
        mov     al, 04h                     ; bit 2 enable fan control
        call    SuperIORegWrite
        
        push    cx
        shr     cl, 1       ;Bit 1 to 6 is used for fan power
        and     cl, FAN_POWER_MASK
        mov     ah, FAN1_POWER_INDEX
        call    SuperIORegRead
        and     al, not FAN_POWER_MASK
        or      al, cl
        btr     al, 0               ;clear bit 0 for using duty cycle.
              
        pop     cx
        cmp     cl, FAN_FULL_POWER   ;Check if full power required
        jne     SetCPUFanPowerSIOWrite ; no them jump to write register
        bts     al, 0       ;yes, then Set bit 0 to 1 for full power.
SetCPUFanPowerSIOWrite:
        mov     ah, FAN1_POWER_INDEX
        call    SuperIORegWrite
                
        pop     ax        
        ret
endif
SetCPUFanPower endp


;------------------------------------------------------------
;
; GetSecondFanPower: 
;
; Entry:  
; Exit: ecx has the CPU Fan power, carry clear
; Modified:
;
GetSecondFanPower proc near
        push    ax
        ;Check To see if Fan1 control is activated.
        mov     ah, FAN2_GPIO32_CTRL_INDEX
        call    SuperIORegRead
        mov     ecx, FAN_FULL_POWER         ;preset to full power
        test    al, 4                      ;Bit 2 enables fan control
        jz      GetSecondFanPowerExit
        
        mov     ah, FAN2_POWER_INDEX
        call    SuperIORegRead
        test    al, 1                      ;If Fan1 pin is high
        jnz     GetSecondFanPowerExit         ; yes, then jump with full power return
        shl     al, 1       ;only bit 1 to 6 are used for fan power.
                        ; and change data range within 00 and FE instead of 0-63.
        xor     ah, ah    
                
        movzx   ecx, ax
GetSecondFanPowerExit:
        
        clc    
        pop     ax    
        
        ret
GetSecondFanPower endp

;------------------------------------------------------------
;
; SetSecondFanPower: 
;
; Entry:  ecx (bit 0 to 5) has the CPU Fan power to set
; Exit:   carry clear means success
; Modified:
;
SetSecondFanPower proc near
        push ax
        
        ;Make Fan2 control active.
        mov     ah, FAN2_GPIO32_CTRL_INDEX
        mov     al, C17_FAN2_CTRL_ENABLE                     ; bit 2 enable fan control bit 0 invert output
        call    IsC18DBoard                
        jnc     NoInvertOutput
        mov     al, C18D_FAN2_CTRL_ENABLE
NoInvertOutput:        
        call    SuperIORegWrite

        push    cx
        shr     cl, 1       ;Bit 1 to 6 is used for fan power
        and     cl, FAN_POWER_MASK
        mov     ah, FAN2_POWER_INDEX
        call    SuperIORegRead
        and     al, not FAN_POWER_MASK
        or      al, cl
        btr     al, 0               ;clear bit 0 for using duty cycle.
        pop     cx
        cmp     cl, FAN_FULL_POWER   ;Check if full power required
        jne     SetSecondFanPowerSIOWrite ; no them jump to write register
        bts     al, 0       ;yes, then Set bit 0 to 1 for full power.
SetSecondFanPowerSIOWrite:
        mov     ah, FAN2_POWER_INDEX
        call    SuperIORegWrite
        
        pop     ax      
        ret

SetSecondFanPower endp
;-------------------------------------------------------------------
;
; IsC18DBoard: Check if it is a C18D board
;
; Entry: None 
; Exit: carry set means it is C18D board
; Modified:
;
IsC18DBoard proc near
        push    ax
        
        stc
        pop     ax
        ret
IsC18DBoard endp

;-------------------------------------------------------------------
;
; SuperIORegRead: Read Super IO register
;
; Entry: AH: Register Index; 
; Exit: AL: the register value read
; Modified: AX
;
SuperIORegRead  proc near
        push    dx
        
        mov     dx, SUPERIO_GPIO_PORT_BASE
        add     dl, ah
        in      al, dx
        
        pop     dx
        ret
SuperIORegRead endp

;------------------------------------------------------------
;
; SuperIORegWrite: Read Super IO register
;
; Entry: AH: Register Index;
;        AL: Register value
; Exit: None
; Modified: 
;
SuperIORegWrite  proc near
        push    dx
        mov     dx, SUPERIO_GPIO_PORT_BASE
        add     dl, ah
        out     dx, al
        pop     dx
        ret
SuperIORegWrite endp

;N07 start
;------------------------------------------------------------
;
; ReadMBInfo: Read motherboard vendor, motherboard model and version
;
; Entry: None
; Exit: Data will be saved in scratch register 1-7.
;       scratch 1: bit0-15: vendor ID
;                  bit 16-31: version
;       scratch 2-7: will be used for motherboard model, one
;               one letter with ASCII encoding.
; Modified: 
;
ReadMBInfo      proc near
        push    dx
        push    eax
        
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH1_REG
        call    GetBoardVersion
        shl     eax, 16
        mov     ax, BOARD_VENDOR_ID
        mov     ecx, eax                             ;N08
        
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH2_REG
        mov     eax, BOARD_MODEL1
        out     dx, eax       
        
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH3_REG
        mov     eax, BOARD_MODEL2
        out     dx, eax       
        
        pop     eax
        pop     dx
        ret                    
ReadMBInfo      endp
;------------------------------------------------------------
;
; GetBoardVersion: Get board version
;
; Entry: None
; Exit:  version is saved in ax
; Modified: 
;
GetBoardVersion proc near
        mov ax, BOARD_VERSION
        ret
GetBoardVersion endp
;N07 end

;N03 Start
;------------------------------------------------------------
;
; GetCMOSLocation0: Return cmos index and bitmap in scratch register 0-7. 
;                   See wpt document for detail of data format.
; ENTRY: 
; Exit:     clear carry
; Modified: 
;
GetCMOSLocation0 proc near
        push    dx
        push    eax
        
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH0_REG
        mov     eax, (CPU_INTERFACE_CMOS_BIT shl 24) + (CPU_INTERFACE_CMOS shl 16) + (SYSPERFORMACE_CMOS_BIT shl 8) + SYSPERFORMACE_CMOS
        out     dx, eax       

        ; scratch register 1 will be load from ecx in SetReturnData.
        mov     ecx, (MEM_TRAS_CMOS_BIT shl 24) + (MEM_TRAS_CMOS shl 16) + (MEMORYTIMING_CMOS_BIT shl 8) + MEMORYTIMING_CMOS

        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH2_REG
        mov     eax, (MEM_TRP_CMOS_BIT shl 24) + (MEM_TRP_CMOS shl 16) + (MEM_TRCD_CMOS_BIT shl 8) + MEM_TRCD_CMOS
        out     dx, eax       

        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH3_REG
        mov     eax, (AGP_8X_SUPPORT_CMOS_BIT shl 24) + (AGP_8X_SUPPORT_CMOS shl 16) + (CASLATENCY_CMOS_BIT shl 8) + CASLATENCY_CMOS
        out     dx, eax       
        
        ;;
        ;; Following are universal for K8 and K7 platform
        ;;
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH4_REG
        mov     eax, (SECOND_BOOT_DEVICE_CMOS_BIT shl 24) + (SECOND_BOOT_DEVICE_CMOS shl 16) + (FIRST_BOOT_DEVICE_CMOS_BIT shl 8) + FIRST_BOOT_DEVICE_CMOS
        out     dx, eax       

        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH5_REG
        mov     eax, (AGP_APERATURE_CMOS_BIT shl 24) + (AGP_APERATURE_CMOS shl 16) + (THIRD_BOOT_DEVICE_CMOS_BIT shl 8) + THIRD_BOOT_DEVICE_CMOS
        out     dx, eax       

        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH6_REG
        mov     eax, (CPU_EXTERNAL_CACHE_CMOS_BIT shl 24) + (CPU_EXTERNAL_CACHE_CMOS shl 16) + (CPU_INTERNAL_CACHE_CMOS_BIT shl 8) + CPU_INTERNAL_CACHE_CMOS
        out     dx, eax       

        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH7_REG
        mov     eax, (CLOCK_MULTIPLIER_CMOS_BIT shl 24) + (CLOCK_MULTIPLIER_CMOS shl 16) + (SSE_INSTRUCTION_CMOS_BIT shl 8) + SSE_INSTRUCTION_CMOS ;N04 ;N07
        out     dx, eax       

        clc
        pop     eax
        pop     dx 
        ret
GetCMOSLocation0 endp
;------------------------------------------------------------
;
; GetCMOSLocation1: Return cmos index and bitmap in scratch register 0-7. 
;                   See wpt document for detail of data format.
; ENTRY: 
; Exit:     clear carry
; Modified: 
;
GetCMOSLocation1 proc near
        push    dx
        push    eax
        
ifdef K8_CPU_SUPPORT
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH0_REG
        mov     eax, (AGP30_SPEED_CMOS_BIT shl 24) + (AGP30_SPEED_CMOS shl 16) + (AGP20_SPEED_CMOS_BIT shl 8) + AGP20_SPEED_CMOS
        out     dx, eax       

        ; scratch register 1 will be load from ecx in SetReturnData.
        mov     ecx, (LDT_SPEED_CMOS_BIT shl 8) + LDT_SPEED_CMOS
else
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH2_REG
        mov     eax, (VCORE_CMOS_BIT shl 24) + (VCORE_CMOS shl 16) + (VAUX_CMOS_BIT shl 8) + VAUX_CMOS
        out     dx, eax       

        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH3_REG
        mov     eax, (VMEM_CMOS_BIT shl 24) + (VMEM_CMOS shl 16) + (VAGP_CMOS_BIT shl 8) + VAGP_CMOS
        out     dx, eax       

        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH4_REG
        mov     eax, (CPUVID_CMOS_BIT shl 8) + CPUVID_CMOS
        out     dx, eax       
endif
        clc
        pop     eax
        pop     dx 

        ret
GetCMOSLocation1 endp

;------------------------------------------------------------
;
; WPTComputeCMOSCheckSumAll: calculate cmos checksum from 10h to 2Eh 
;                            and 40h to 7Bh
;
; ENTRY: 
; Exit:     clear carry
; Modified: ax
;
WPTComputeCMOSCheckSumAll proc near            
        push    cx
        push    dx

        mov     cl, 10h NMI_OFF
        mov     dl, 2Eh NMI_OFF
        call    WPTComputeCMOSCheckSum
        
        mov     cl, 40h NMI_OFF
        mov     dl, 7Bh NMI_OFF
        call    WPTComputeCMOSCheckSum
        
        clc
        pop     dx
        pop     cx
        ret                              
WPTComputeCMOSCheckSumAll endp


;------------------------------------------------------------
;
; WPTComputeCMOSCheckSum: calculate cmos checksum from cl to dl
;
; ENTRY:
;       cl: start offset
;       dl: end offset 
; Exit: 
; Modified: ax
;
WPTComputeCMOSCheckSum proc near                ;N02
        push    bx
        
        xor     bx, bx
WPTCMOS_Checksum:                 ;Cmos Check Sum [40h-7Ah]
        mov     al, cl
        call    SMI_Get_Cmos
        mov     ah, 0
        add     bx, ax
        inc     cl
        cmp     cl, dl
        je      SaveCheckSum
        jmp     WPTCMOS_Checksum
SaveCheckSum:
        mov     al, dl
        mov     ah, bh
        call    SMI_Set_Cmos
        
        mov     al, dl
        inc     al
        mov     ah, bl
        call    SMI_Set_Cmos
        
        pop     bx   
        ret                           
WPTComputeCMOSCheckSum endp
;N03 End
;N10 start
;--------------------------------------------------------------------
;
; GetDimmAddrInfo: Function code 2Ah; Get Dimm address and slot info
;
; ENTRY:None.
; Exit: None
; Modified: ecx
;
GetDimmAddrInfo proc near
        push    dx
        push    eax
        
        mov     dx, SMI_IO_BASE_ADDR+SW_SMI_SCRATCH0_REG
        mov     eax, (DIMM1_SMBUS_SEG shl 28) + (DIMM1_SLOT_NO shl 24) + (DIMM1_SMBUSADDR shl 16) + (DIMM0_SMBUS_SEG shl 12) + (DIMM0_SLOT_NO shl 8) + DIMM0_SMBUSADDR
        out     dx, eax       

        ; scratch register 1 will be load from ecx in SetReturnData.
        mov     ecx, (DIMM3_SMBUS_SEG shl 28) + (DIMM3_SLOT_NO shl 24) + (DIMM3_SMBUSADDR shl 16) + (DIMM2_SMBUS_SEG shl 12) + (DIMM2_SLOT_NO shl 8) + DIMM2_SMBUSADDR

        clc
        pop     eax
        pop     dx 
        
        ret
GetDimmAddrInfo endp
;N10 end
endif   ;   WPT_INTERFACE_SUPPORT
